/**@file
 * This file is part of the CANopen Library Unit Test Suite.
 *
 * @copyright 2021 N7 Space Sp. z o.o.
 *
 * Unit Test Suite was developed under a programme of,
 * and funded by, the European Space Agency.
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef LELY_UNIT_TEST_NMT_STARTUP_HPP_
#define LELY_UNIT_TEST_NMT_STARTUP_HPP_

#include "obj-init/obj-init.hpp"

/// 0x1f80: NMT Start-up
struct Obj1f80NmtStartup : ObjValueInitT<0x1f80u, CO_DEFTYPE_UNSIGNED32> {
  static const sub_type MASTER_BIT = 0x01u;
  static const sub_type AUTOSTART_BIT = 0x04u;
  static const sub_type RESET_NODES_ON_ERR = 0x10u;
  static const sub_type STOP_NODES_ON_ERR = 0x40u;
};

#endif  // LELY_UNIT_TEST_NMT_STARTUP_HPP_
